#************************************************************************************
#                                                                                                  
#                                 Ex. SHT31.py                                       
#                                                                                                  
#************************************************************************************
#                                                                                                  
#  Board MCU   : RASPBERRY PI 3 MODEL B                                                         
#  Editor-IDE  : Geany 1.29                                                                      
#  Target Board Interface : ET-IOT HAT + ET-SENSOR SHT31 (I2C-3V3)                                                      
#                                                                                                                                                                                                                                             
#************************************************************************************

import smbus
import time

#--- Open I2C interface ---
bus = smbus.SMBus(1)    # use Port i2c-1

#--- Define I2C Address of TEMP-SHT31 ---
SHT31_ADDR  = 0x44      # Temp SHT31 I2C device address

#--- Define Valiable Keep value Teme & RH ---
cTemp = 0
RH    = 0

        
#---------------------------------------
#           Function-Delay
#---------------------------------------
# dy = value delay unit (ms)
#---------------------------------------
def delay_ms(dy):
	time.sleep(dy/1000.0)

#----------------------------------------------
#            Function-SHT31 Write 
#----------------------------------------------
# 
# Send measurement command,        0x2C
# High repeatability measurement   0x06
#-----------------------------------------------
def SHT31_write():
	bus.write_i2c_block_data(SHT31_ADDR,0x2C,[0x06])
	delay_ms(500)

#----------------------------------------------
#            Function-SHT31 Read 
#----------------------------------------------
# 
# Read data back from 0x00(00), 6 bytes
# data = Temp MSB[0], Temp LSB[1], Temp CRC[2], Humididty MSB[3], Humidity LSB[4], Humidity CRC[5]
#----------------------------------------------
def SHT31_read():
	
	global cTemp
	global RH
  
	data = bus.read_i2c_block_data(SHT31_ADDR,0x00,6) # Read Data SHT31 6 Byte
	
	# Convert the data 6 Byte
	temp = data[0] * 256 + data[1]            # Total Data temp  ByteHigh and Low
	cTemp = -45 + (175 * temp / 65535.0)      # Calculate Data temp to degree
	
	humidity =  data[3] * 256 + data[4]       # Total Data humidity  Byte High and Low
	RH = (100*humidity)/65535.0               # Calculate Data humidity to Relative Humidity(%RH)

#----------------------------------------------
#       Function-Display Temp&Humidity(RH)
#----------------------------------------------     
def Show_Data():
	print ("Temperature : %.2f C" %cTemp)     # Print Temp to screen
	print ("Humidity : %.2f %%" %RH)          # Print Humidity to screen
	print (" ")

while True:
	SHT31_write()
	SHT31_read()
	Show_Data()
